/////////////////////////////////////////////////////////////
// CINEMA SDK : BITMAP FILTER                              //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __X4D_MACROS_H
#define __X4D_MACROS_H

#ifndef _INC_STDDEF
#ifndef __cstddef__
#ifndef _MSL_STDDEF_H
#ifndef _MSL_CSTDDEF
#define offsetof(s,m)   ((ULONG)&(((s *)0)->m))						// from stddef
#endif
#endif
#endif
#endif

//----------------------------------------------------------------------------------------
// Structure alignment
//----------------------------------------------------------------------------------------
#define	VARIABLE_ARRAY_SIZE	1																// constant for arrays with variable size

//----------------------------------------------------------------------------------------
// Byte order for the destination platform
//----------------------------------------------------------------------------------------
#if __MWERKS__																							// Metrowerks CodeWarrior

#define	LITTLE_ENDIAN	__INTEL__

#elif _MSC_VER																							// MSVC

#define	LITTLE_ENDIAN	1

#elif	__GNUC__																							// GNU
#if defined( powerpc )																			// PPC-Code

#define	LITTLE_ENDIAN	0

#elif defined( m68k )																				// 68k-Code

#define	LITTLE_ENDIAN	0

#else																												// x86-Code

#define	LITTLE_ENDIAN	1

#endif
#else

#define	LITTLE_ENDIAN	0																			// default

#endif

//----------------------------------------------------------------------------------------
// Macros for changing the byte order
//----------------------------------------------------------------------------------------
#define	REVERSE16( a )		(WORD) (((UWORD)(a) >> 8 ) | ((UWORD)(a) << 8 ))
#define	REVERSEu16( a )		(UWORD) (((UWORD)(a) >> 8 ) | ((UWORD)(a) << 8 ))

#define	REVERSE32( a )		(LONG) (((ULONG)(a) << 24 ) | (((ULONG)(a) & 0xff00L ) << 8 ) | \
													(((ULONG)(a) >> 8 ) & 0xff00L ) | ((ULONG)(a) >> 24 ))

#define	REVERSEu32( a )		(ULONG) (((ULONG)(a) << 24 ) | (((ULONG)(a) & 0xff00UL ) << 8 ) | \
													(((ULONG)(a) >> 8 ) & 0xff00UL ) | ((ULONG)(a) >> 24 ))

//----------------------------------------------------------------------------------------
// Macros for converting LITTLE_ENDIAN/BIG_ENDIAN to destination byte order
//----------------------------------------------------------------------------------------
#if LITTLE_ENDIAN

#define HOST_2_LENDIAN_16( a ) ( a )
#define HOST_2_LENDIAN_32( a ) ( a )
#define HOST_2_BENDIAN_16( a ) ( REVERSEu16( a ))
#define HOST_2_BENDIAN_32( a ) ( REVERSEu32( a ))

#define LENDIAN_2_HOST_16( a ) ( a )
#define LENDIAN_2_HOST_32( a ) ( a )
#define BENDIAN_2_HOST_16( a ) ( REVERSEu16( a ))
#define BENDIAN_2_HOST_32( a ) ( REVERSEu32( a ))

#else																												// friendly cpu

#define HOST_2_LENDIAN_16( a ) ( REVERSEu16( a ))
#define HOST_2_LENDIAN_32( a ) ( REVERSEu32( a ))
#define HOST_2_BENDIAN_16( a ) ( a )
#define HOST_2_BENDIAN_32( a ) ( a )

#define LENDIAN_2_HOST_16( a ) ( REVERSEu16( a ))
#define LENDIAN_2_HOST_32( a ) ( REVERSEu32( a ))
#define BENDIAN_2_HOST_16( a ) ( a )
#define BENDIAN_2_HOST_32( a ) ( a )

#endif																											// LITTLE_ENDIAN

//----------------------------------------------------------------------------------------
// Character constants
//----------------------------------------------------------------------------------------
#if LITTLE_ENDIAN																						// reverse byte order

#define	CHAR_CONST32( a )	(ULONG) (((ULONG)(a) << 24 ) | (((ULONG)(a) & 0xff00UL ) << 8 ) | \
												(((ULONG)(a) >> 8 ) & 0xff00UL ) | ((ULONG)(a) >> 24 ))

#else																												// usual byte order

#define	CHAR_CONST32( a )	(ULONG) ( a )

#endif

#endif
